;       .title  "Test Software"
; Routine to demo code tracking.
; Bob Stricklin N5BRG
; 5/26/95
;

#include  "REGS.INC"
#include  "MONITOR.INC"

; GETVAL_MEM storage used
; GET2HEXMEM storage used
; GET4HEXMEM storage used
; PRVAL_MEM  storage used

MON1      .EQU     060h ;  monitor scratch register
MON2      .EQU     061h ;  monitor scratch register
MON3      .EQU     062h ;  monitor scratch register
MON4      .EQU     063h ;  monitor scratch register
MON5      .EQU     064h ;  monitor scratch register
MON6      .EQU     065h ;  monitor scratch register
MON7      .EQU     066h ;  monitor scratch register
MON8      .EQU     067h ;  monitor scratch register
MON9      .EQU     068h ;  monitor scratch register
MON10     .EQU     072h
MON11     .EQU     073h
TRACE_LOC .EQU     074h

; Add this memory pointer to your code.
MEM_PTR   .EQU     049h ;  Location to store counter.


	.ORG     1000h

        B       INIT
	B       INIT
	B       INIT
	B       INIT


INIT

	LDPK    8           ; Set for external memory
	CALL	SD_CRLF	    ; Move to next line after 'G'

; Set up memory location to store tracking counters.
; You must zero the counter locations before your code starts.
	LRLK	AR6,04000h
	LARP    AR6
ZERO	ZAC
	SACL	*+
	SAR	AR6,MON10
	LAC	MON10
	XORK	7FFFh
	BNZ	ZERO

MW

; Incriment a counter for this part of the code.
	CALL    TRACK
	CALL	TRACE
	CALL	TRACE2

; L202 ON
	SACL    61h            ; direct data memory address from 61h
	LT      61h            ; load T register to 
	LACT    60h            ; load value at memory 60h
	XORK    0400h          ; set bit D10 high (LED active)
	SACL    60h
	OUT     60h,06h        ; send value to TNC latch (hi byte)
	CALL    WAIT4
	LACT    60h
	XORK    0400h
	SACL    60h
	OUT     60h,06h
; Incriment a counter for this part of the code.
	CALL	TRACK
	CALL	TRACE2

; L203 ON
	ZAC
	SACL    61h
	LT      61h
	LACT    60h
	XORK    0200h
	SACL    60h
	OUT     60h,06h
	CALL    WAIT4
	LACT    60h
	XORK    0200h
	SACL    60h
	OUT     60h,06h
; Incriment a counter for this part of the code.
	CALL	TRACK
	CALL	TRACE2

; L204 ON
	ZAC
	SACL    61h
	LT      61h
	LACT    60h
	XORK    0100h
	SACL    60h
	OUT     60h,06h
	CALL    WAIT4
	LACT    60h
	XORK    0100h
	SACL    60h
	OUT     60h,06h
; Incriment a counter for this part of the code.
	CALL	TRACK
	CALL	TRACE2

        B       MW

TRACE
; Store the acc in memory locations not used by your code.
	SACL    MON10
	SACH    MON9 
	POP		; Puts the CALL return address in acc
	PUSH		; Restore the return address for this CALL
	SUBK	2	; Adjust to exact location of the CALL instruction
	SACL    PRVAL_MEM
	CALL    PRVAL16
	CALL    SD_CRLF
	LAC     MON9,8	; Loads the upper 8 bits of acc
	LAC     MON10   ; Restore low acc
	RET

TRACE2
; Store the acc in memory locations not used by your code.
	SACL    MON10
	SACH    MON9 
	POP		; Puts the CALL return address in acc
	PUSH		; Restore the return address for this CALL
	SUBK	2	; Adjust to exact location of the CALL instruction
	SACL    TRACE_LOC ; Check this loscation after program hangs
			; using monitor. Location is 0474h here.
	LAC     MON9,8	; Loads the upper 8 bits of acc
	LAC     MON10   ; Restore low acc
	RET

TRACK
        SST1    MON6    ; Saves SST1
        SST     MON7    ; Saves SST
	LARP    AR6

; Store the acc in memory locations not used by your code.
	SACL    MON10
	SACH    MON9 
	POP		; Puts the CALL return address in acc
	PUSH		; Restore the return address for this CALL
	SUBK	2	; Adjust to exact location of the CALL instruction
	ADLK	3000h	; Your program starts at 1000h so this moves us
			; up to 4000h. Your program must be less than 3000h
			; in length or this will need to be moved up.
; Store the acc in a memory location not used by your code.
	SACL    MON8
	LAR	AR6,MON8
;	SACL    PRVAL_MEM ; Uncomment next 3 lines to print CALL address
;	CALL    PRVAL16
;	CALL    SP2
	LAC	*
	ADDK	1
	SACL	*
;	SACL    PRVAL_MEM ; Uncomment next 3 lines to print number of cycles
;	CALL    PRVAL16
;	CALL    SD_CRLF
	LAC     MON9,8	; Loads the upper 8 bits of acc
	LAC     MON10   ; Restore low acc
	LDPK    0h	; LST always works from page 0
	LST1    MON6	; Restore register value
	LST     MON7    ; Restore register value
	RET

WAIT4
	LRLK	AR2,050h
	CALL	MWAIT_A
	RET


        .END
